/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.user.service.impl;

import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.user.repo.RoleRepository;
import com.tp_link.eap.user.service.RoleService;
import com.tp_link.eap.util.a.a;
import com.tp_link.eap.util.p.b;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="roleService")
public class RoleServiceImpl
extends com.tp_link.eap.i.a.a<Role>
implements RoleService {
    @Autowired
    private RoleRepository a;

    @Override
    public List<Role> getAll() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public Role getRoleByName(String name) {
        if (name == null) {
            return null;
        }
        return this.a.findByName(name);
    }

    @Override
    public Role getRoleById(String id) {
        if (id == null) {
            return null;
        }
        return (Role)this.a.findOne((Serializable)((Object)id));
    }

    @Override
    public int getRoleCounts() {
        return (int)this.a.count();
    }

    @Override
    public OperationResult addRole(Role role) {
        OperationResult operationResult = this.a(role);
        if (!operationResult.isSuccess()) {
            return operationResult;
        }
        if (this.isExists(role.getName())) {
            return new OperationResult(false, String.format("Role %s already exists.", role.getName()));
        }
        Calendar calendar = Calendar.getInstance();
        role.setCreatedTime(calendar.getTime());
        this.a.save(role);
        return new OperationResult(true, String.format("Add role %s successfully.", role.getName()));
    }

    @Override
    public OperationResult delRoleByName(String name) {
        Role role = this.a.findByName(name);
        if (role == null) {
            return new OperationResult(false, String.format("Role %s not exists.", name));
        }
        this.a.delete(role);
        return new OperationResult(true, String.format("Delete role %s successfully.", name));
    }

    @Override
    public boolean isDefault(String name) {
        Role role = this.a.findByName(name);
        if (role == null) {
            return false;
        }
        return role.isDefault();
    }

    @Override
    public boolean isExists(String name) {
        Role role = this.a.findByName(name);
        return role != null;
    }

    @Override
    public OperationResult updateRole(Role role) {
        OperationResult operationResult = this.a(role);
        if (!operationResult.isSuccess()) {
            return operationResult;
        }
        if (!this.isExists(role.getName())) {
            return new OperationResult(false, String.format("Role %s not exists.", role.getName()));
        }
        Role role2 = this.getRoleByName(role.getName());
        if (!role2.getName().equals(role.getName())) {
            return new OperationResult(false, "Can not modify role name while updating role.");
        }
        if (role2.isDefault()) {
            return new OperationResult(false, "Can not modify default role.");
        }
        role2.setDescription(role.getDescription());
        role2.setDefault(false);
        role2.setPermissions(role.getPermissions());
        this.a.save(role2);
        return new OperationResult(true, String.format("Update role %s successfully.", role.getName()));
    }

    public List<Role> getList(QueryPage queryPage) {
        List<Role> list = this.getList(queryPage, null, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Role> getList(QueryPage queryPage, QuerySort querySort) {
        List<Role> list = this.getList(queryPage, querySort, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Role> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Role> list = this.getList(queryPage, null, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Role> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Role> list = this.a.getByFilters(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(null, null, filters, searchFilters).size();
    }

    private OperationResult a(Role role) {
        if (role == null) {
            return new OperationResult(false, "Illegal parameter");
        }
        if (!b.c((String)role.getName(), (int)com.tp_link.eap.user.a.b.c, (int)com.tp_link.eap.user.a.b.d)) {
            return new OperationResult(false, "Invalid role name");
        }
        return new OperationResult(true, String.format("Role %s is valid", role.getName()));
    }
}

